<?php

namespace Digits\SocialLogin\Auths;

use DigitsSocialOAuth2;

class RedditAuth extends SocialLoginAuth
{
    private $client_id;
    private $redirect_url;
    private $icon_only;
    private $settings;

    function __construct($settings, $social_info, $icon_only)
    {
        $this->settings = $settings;
        $this->client_id = esc_attr($settings['clientID']);
        $this->redirect_url = $social_info['redirect_uri'];
        $this->icon_only = $icon_only;


        parent::__construct();

    }

    public function render()
    {
        $this->default_layout('digits_reddit_login', 'Reddit');

    }

    public function get_url()
    {
        $query = [
            'client_id' => urlencode($this->client_id),
            'scope' => 'identity',
            'response_type' => 'code',
            'redirect_uri' => urlencode($this->redirect_url),
            'state' => urlencode(wp_create_nonce('reddit_login')),
            'duration' => 'temporary'
        ];
        $base_url = 'https://www.reddit.com/api/v1/authorize';

        return add_query_arg($query, $base_url);
    }


    public function enqueue_scripts()
    {
    }

    public function process_token()
    {

    }

    public function process_oauth_token()
    {
        if (empty($_REQUEST['code'])) {
            $this->invalid_info();
            die();
        }
        if (!wp_verify_nonce($_REQUEST['state'], 'reddit_login')) {
            $this->nonce_fail();
            die();
        }
        try {
            $userAgent = $this->settings['appName'] . '/1.0 by ' . $this->settings['redditUsername'];

            $code = $_REQUEST['code'];
            $accessTokenUrl = 'https://www.reddit.com/api/v1/access_token';

            $client = new DigitsSocialOAuth2\Client($this->client_id, $this->settings['clientSecretID'], DigitsSocialOAuth2\Client::AUTH_TYPE_AUTHORIZATION_BASIC);
            $client->setCurlOption(CURLOPT_USERAGENT, $userAgent);

            $params = array("code" => $code, "redirect_uri" => $this->redirect_url);
            $response = $client->getAccessToken($accessTokenUrl, "authorization_code", $params);


            $accessTokenResult = $response["result"];

            if (empty($accessTokenResult["access_token"])) {
                $this->invalid_info();
                die();
            }

            $client->setAccessToken($accessTokenResult["access_token"]);
            $client->setAccessTokenType(DigitsSocialOAuth2\Client::ACCESS_TOKEN_BEARER);

            $response = $client->fetch("https://oauth.reddit.com/api/v1/me.json");
            $response = $response['result'];

            $name = $response['subreddit']['display_name'];
            $username = $response['subreddit']['display_name_prefixed'];
            $reddit_id = $response['id'];

            $response = digits_social_create_user($name, '', 'reddit', $username, $reddit_id);

            $this->success_view($response);
        } catch (\Exception $e) {
            $this->error_view($e);
        }
    }
}
